using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Text.RegularExpressions;
using System.Threading;
using System.Reflection;

namespace DependencyResolver {
    public class Form1 : System.Windows.Forms.Form {
        private bool _enableExes = false;
        private const int WM_LBUTTONUP = 0x0202;
        private object _lock = new object();
        private bool _doCopy = true;
        private string _copyContents = "";
        private string _searchWord = "";
        private bool _caseSen, _matchWhole, _searchSub;
        private ListView listView1;
        private System.Windows.Forms.MainMenu mainMenu1;
        private System.Windows.Forms.ColumnHeader _asmName;
        private System.Windows.Forms.ColumnHeader _dAsm;
        private System.Windows.Forms.ColumnHeader _reqVer;
        private System.Windows.Forms.ColumnHeader _resVer;
        private System.Windows.Forms.MenuItem menuItem1;
        private System.Windows.Forms.MenuItem _resGac;
        private System.Windows.Forms.MenuItem _resAt;
        private System.Windows.Forms.MenuItem _edit;
        private System.Windows.Forms.MenuItem _copy;
        private System.Windows.Forms.MenuItem _selectAll;
        private Regex _r;
        private System.Windows.Forms.ColumnHeader _refExists;
        private System.Windows.Forms.ColumnHeader _refResolves;
        private System.Windows.Forms.ContextMenu contextMenu1;
        private System.Windows.Forms.MenuItem menuItem3;
        private System.Windows.Forms.MenuItem menuItem4;
        private System.Windows.Forms.MenuItem menuItem5;
        private System.Windows.Forms.MenuItem menuItem6;
        private System.ComponentModel.IContainer components;
        private ListViewItem _back = new ListViewItem(), _forward = new ListViewItem();
        private System.Windows.Forms.MenuItem _nav;
        private System.Windows.Forms.MenuItem menuItem10;
        private System.Windows.Forms.MenuItem menuItem11;
        private System.Windows.Forms.MenuItem _back1;
        private System.Windows.Forms.MenuItem _back2;
        private System.Windows.Forms.ToolBar toolBar1;
        private System.Windows.Forms.ToolBarButton _backButton;
        private System.Windows.Forms.ToolBarButton _forwardButton;
        private System.Windows.Forms.MenuItem menuItem7;
        private System.Windows.Forms.MenuItem menuItem9;
        private System.Windows.Forms.OpenFileDialog openFileDialog1;
        private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog1;
        private System.Windows.Forms.MenuItem menuItem12;
        private System.Windows.Forms.MenuItem menuItem13;
        private System.Windows.Forms.MenuItem _resCM;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem menuItem14;
        private System.Windows.Forms.ToolBarButton _gac;
        private System.Windows.Forms.ToolBarButton _file;
        private System.Windows.Forms.ToolBarButton _folder;
        private System.Windows.Forms.MenuItem menuItem15;
        private System.Windows.Forms.MenuItem menuItem16;
        private System.Windows.Forms.MenuItem menuItem18;
        private System.Windows.Forms.MenuItem _drgFrom;
        private System.Windows.Forms.MenuItem menuItem17;
        private System.Windows.Forms.MenuItem _find;
        private System.Windows.Forms.ImageList _images;
        private System.Windows.Forms.MenuItem _exeMenuOption;
        private System.Windows.Forms.MenuItem menuItem8;
        Mutex mutex = new Mutex();

        public Form1() {
            _r = new Regex(@"Version=(?<version>\d+\.\d+\.\d+\.\d+)", RegexOptions.ExplicitCapture);
            InitializeComponent();
        }
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
            this.listView1 = new System.Windows.Forms.ListView();
            this._asmName = new System.Windows.Forms.ColumnHeader();
            this._dAsm = new System.Windows.Forms.ColumnHeader();
            this._reqVer = new System.Windows.Forms.ColumnHeader();
            this._resVer = new System.Windows.Forms.ColumnHeader();
            this._refExists = new System.Windows.Forms.ColumnHeader();
            this._refResolves = new System.Windows.Forms.ColumnHeader();
            this.contextMenu1 = new System.Windows.Forms.ContextMenu();
            this._resCM = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.menuItem13 = new System.Windows.Forms.MenuItem();
            this.menuItem12 = new System.Windows.Forms.MenuItem();
            this.menuItem16 = new System.Windows.Forms.MenuItem();
            this.menuItem15 = new System.Windows.Forms.MenuItem();
            this.menuItem11 = new System.Windows.Forms.MenuItem();
            this._back2 = new System.Windows.Forms.MenuItem();
            this.menuItem10 = new System.Windows.Forms.MenuItem();
            this.menuItem4 = new System.Windows.Forms.MenuItem();
            this.menuItem14 = new System.Windows.Forms.MenuItem();
            this.menuItem5 = new System.Windows.Forms.MenuItem();
            this.menuItem6 = new System.Windows.Forms.MenuItem();
            this._images = new System.Windows.Forms.ImageList(this.components);
            this.mainMenu1 = new System.Windows.Forms.MainMenu();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this._resAt = new System.Windows.Forms.MenuItem();
            this._resGac = new System.Windows.Forms.MenuItem();
            this.menuItem9 = new System.Windows.Forms.MenuItem();
            this.menuItem7 = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItem18 = new System.Windows.Forms.MenuItem();
            this._drgFrom = new System.Windows.Forms.MenuItem();
            this._edit = new System.Windows.Forms.MenuItem();
            this._copy = new System.Windows.Forms.MenuItem();
            this._selectAll = new System.Windows.Forms.MenuItem();
            this.menuItem17 = new System.Windows.Forms.MenuItem();
            this._find = new System.Windows.Forms.MenuItem();
            this._nav = new System.Windows.Forms.MenuItem();
            this._back1 = new System.Windows.Forms.MenuItem();
            this.menuItem8 = new System.Windows.Forms.MenuItem();
            this.toolBar1 = new System.Windows.Forms.ToolBar();
            this._gac = new System.Windows.Forms.ToolBarButton();
            this._folder = new System.Windows.Forms.ToolBarButton();
            this._file = new System.Windows.Forms.ToolBarButton();
            this._backButton = new System.Windows.Forms.ToolBarButton();
            this._forwardButton = new System.Windows.Forms.ToolBarButton();
            this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
            this.folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
            this._exeMenuOption = new System.Windows.Forms.MenuItem();
            this.SuspendLayout();
            // 
            // listView1
            // 
            this.listView1.AllowColumnReorder = true;
            this.listView1.AllowDrop = true;
            this.listView1.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this._asmName,
																						this._dAsm,
																						this._reqVer,
																						this._resVer,
																						this._refExists,
																						this._refResolves});
            this.listView1.ContextMenu = this.contextMenu1;
            this.listView1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listView1.FullRowSelect = true;
            this.listView1.GridLines = true;
            this.listView1.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.listView1.LabelWrap = false;
            this.listView1.Location = new System.Drawing.Point(32, 0);
            this.listView1.Name = "listView1";
            this.listView1.Size = new System.Drawing.Size(824, 481);
            this.listView1.SmallImageList = this._images;
            this.listView1.TabIndex = 0;
            this.listView1.View = System.Windows.Forms.View.Details;
            this.listView1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.OnMouseDown);
            this.listView1.DoubleClick += new System.EventHandler(this.listView1_DoubleClick);
            this.listView1.DragDrop += new System.Windows.Forms.DragEventHandler(this.OnDragDropEvent);
            this.listView1.DragEnter += new System.Windows.Forms.DragEventHandler(this.OnDragEnter);
            // 
            // _asmName
            // 
            this._asmName.Text = "Assembly Name";
            this._asmName.Width = 156;
            // 
            // _dAsm
            // 
            this._dAsm.Text = "Dependent Assembly";
            this._dAsm.Width = 207;
            // 
            // _reqVer
            // 
            this._reqVer.Text = "Referenced Version";
            this._reqVer.Width = 116;
            // 
            // _resVer
            // 
            this._resVer.Text = "Resolved Version";
            this._resVer.Width = 100;
            // 
            // _refExists
            // 
            this._refExists.Text = "Reference Exists";
            this._refExists.Width = 96;
            // 
            // _refResolves
            // 
            this._refResolves.Text = "Reference Resolves";
            this._refResolves.Width = 121;
            // 
            // contextMenu1
            // 
            this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this._resCM,
																						 this.menuItem16,
																						 this.menuItem15,
																						 this.menuItem11,
																						 this._back2,
																						 this.menuItem10,
																						 this.menuItem4,
																						 this.menuItem14,
																						 this.menuItem5,
																						 this.menuItem6});
            // 
            // _resCM
            // 
            this._resCM.Index = 0;
            this._resCM.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.menuItem3,
																				   this.menuItem13,
																				   this.menuItem12});
            this._resCM.Text = "Resolve";
            // 
            // menuItem3
            // 
            this.menuItem3.Index = 0;
            this.menuItem3.Text = "GAC";
            this.menuItem3.Click += new System.EventHandler(this.ResolveGacAsms);
            // 
            // menuItem13
            // 
            this.menuItem13.Index = 1;
            this.menuItem13.Text = "Folder";
            this.menuItem13.Click += new System.EventHandler(this.ResolveAt);
            // 
            // menuItem12
            // 
            this.menuItem12.Index = 2;
            this.menuItem12.Text = "File";
            this.menuItem12.Click += new System.EventHandler(this.ResolveAtFile);
            // 
            // menuItem16
            // 
            this.menuItem16.Index = 1;
            this.menuItem16.Text = "-";
            // 
            // menuItem15
            // 
            this.menuItem15.Index = 2;
            this.menuItem15.Text = "Show";
            this.menuItem15.Click += new System.EventHandler(this.listView1_DoubleClick);
            // 
            // menuItem11
            // 
            this.menuItem11.Index = 3;
            this.menuItem11.Text = "-";
            // 
            // _back2
            // 
            this._back2.Enabled = false;
            this._back2.Index = 4;
            this._back2.Shortcut = System.Windows.Forms.Shortcut.CtrlB;
            this._back2.Text = "Back";
            this._back2.Click += new System.EventHandler(this.Back);
            // 
            // menuItem10
            // 
            this.menuItem10.Enabled = false;
            this.menuItem10.Index = 5;
            this.menuItem10.Text = "Forward";
            this.menuItem10.Click += new System.EventHandler(this.Forward);
            // 
            // menuItem4
            // 
            this.menuItem4.Index = 6;
            this.menuItem4.Text = "-";
            // 
            // menuItem14
            // 
            this.menuItem14.Index = 7;
            this.menuItem14.Text = "Clear";
            this.menuItem14.Click += new System.EventHandler(this.Clear);
            // 
            // menuItem5
            // 
            this.menuItem5.Index = 8;
            this.menuItem5.Text = "Copy";
            this.menuItem5.Click += new System.EventHandler(this.Copy);
            // 
            // menuItem6
            // 
            this.menuItem6.Index = 9;
            this.menuItem6.Text = "Select all";
            this.menuItem6.Click += new System.EventHandler(this.SelectAll);
            // 
            // _images
            // 
            this._images.ColorDepth = System.Windows.Forms.ColorDepth.Depth24Bit;
            this._images.ImageSize = new System.Drawing.Size(16, 16);
            this._images.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("_images.ImageStream")));
            this._images.TransparentColor = System.Drawing.Color.Fuchsia;
            // 
            // mainMenu1
            // 
            this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1,
																					  this._edit,
																					  this._nav});
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 0;
            this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this._resAt,
																					  this.menuItem2,
																					  this.menuItem18,
																					  this._drgFrom,
																					  this._exeMenuOption});
            this.menuItem1.Text = "&Action";
            // 
            // _resAt
            // 
            this._resAt.Index = 0;
            this._resAt.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this._resGac,
																				   this.menuItem9,
																				   this.menuItem7});
            this._resAt.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
            this._resAt.Text = "Resolve Assemblies At";
            // 
            // _resGac
            // 
            this._resGac.Index = 0;
            this._resGac.Shortcut = System.Windows.Forms.Shortcut.CtrlG;
            this._resGac.Text = "GAC";
            this._resGac.Click += new System.EventHandler(this.ResolveGacAsms);
            // 
            // menuItem9
            // 
            this.menuItem9.Index = 1;
            this.menuItem9.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
            this.menuItem9.Text = "Folder Level";
            this.menuItem9.Click += new System.EventHandler(this.ResolveAt);
            // 
            // menuItem7
            // 
            this.menuItem7.Index = 2;
            this.menuItem7.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
            this.menuItem7.Text = "File Level";
            this.menuItem7.Click += new System.EventHandler(this.ResolveAtFile);
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 1;
            this.menuItem2.Shortcut = System.Windows.Forms.Shortcut.Del;
            this.menuItem2.Text = "Clear";
            this.menuItem2.Click += new System.EventHandler(this.Clear);
            // 
            // menuItem18
            // 
            this.menuItem18.Index = 2;
            this.menuItem18.Text = "-";
            // 
            // _drgFrom
            // 
            this._drgFrom.Index = 3;
            this._drgFrom.RadioCheck = true;
            this._drgFrom.Text = "Enable Drag From to Copy";
            this._drgFrom.Click += new System.EventHandler(this.DragFromEnabled);
            // 
            // _edit
            // 
            this._edit.Index = 1;
            this._edit.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				  this._copy,
																				  this._selectAll,
																				  this.menuItem17,
																				  this._find});
            this._edit.Text = "&Edit";
            // 
            // _copy
            // 
            this._copy.Index = 0;
            this._copy.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
            this._copy.Text = "&Copy";
            this._copy.Click += new System.EventHandler(this.Copy);
            // 
            // _selectAll
            // 
            this._selectAll.Index = 1;
            this._selectAll.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
            this._selectAll.Text = "S&elect All";
            this._selectAll.Click += new System.EventHandler(this.SelectAll);
            // 
            // menuItem17
            // 
            this.menuItem17.Index = 2;
            this.menuItem17.Text = "-";
            // 
            // _find
            // 
            this._find.Index = 3;
            this._find.Shortcut = System.Windows.Forms.Shortcut.CtrlF;
            this._find.Text = "Find";
            this._find.Click += new System.EventHandler(this.Find);
            // 
            // _nav
            // 
            this._nav.Index = 2;
            this._nav.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				 this._back1,
																				 this.menuItem8});
            this._nav.Text = "&Navigation";
            // 
            // _back1
            // 
            this._back1.Enabled = false;
            this._back1.Index = 0;
            this._back1.Shortcut = System.Windows.Forms.Shortcut.CtrlB;
            this._back1.Text = "&Back";
            this._back1.Click += new System.EventHandler(this.Back);
            // 
            // menuItem8
            // 
            this.menuItem8.Enabled = false;
            this.menuItem8.Index = 1;
            this.menuItem8.Shortcut = System.Windows.Forms.Shortcut.CtrlF;
            this.menuItem8.Text = "&Forward";
            this.menuItem8.Click += new System.EventHandler(this.Forward);
            // 
            // toolBar1
            // 
            this.toolBar1.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
            this.toolBar1.AutoSize = false;
            this.toolBar1.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																						this._gac,
																						this._folder,
																						this._file,
																						this._backButton,
																						this._forwardButton});
            this.toolBar1.ButtonSize = new System.Drawing.Size(50, 10);
            this.toolBar1.Divider = false;
            this.toolBar1.Dock = System.Windows.Forms.DockStyle.Left;
            this.toolBar1.DropDownArrows = true;
            this.toolBar1.Location = new System.Drawing.Point(0, 0);
            this.toolBar1.Name = "toolBar1";
            this.toolBar1.ShowToolTips = true;
            this.toolBar1.Size = new System.Drawing.Size(32, 481);
            this.toolBar1.TabIndex = 1;
            this.toolBar1.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.TooBarButtonPress);
            // 
            // _gac
            // 
            this._gac.Tag = "__GAC__";
            this._gac.Text = " Gac";
            this._gac.ToolTipText = "Resolve Assemblies in the GAC";
            // 
            // _folder
            // 
            this._folder.Tag = "__FOLDER__";
            this._folder.Text = "  Dir  ";
            this._folder.ToolTipText = "Resolves all assemblies in the given folder";
            // 
            // _file
            // 
            this._file.Tag = "__FILE__";
            this._file.Text = " File ";
            this._file.ToolTipText = "Resolves Specific Assembly";
            // 
            // _backButton
            // 
            this._backButton.Enabled = false;
            this._backButton.Tag = "__BACK__";
            this._backButton.Text = "<--";
            this._backButton.ToolTipText = "Go Back";
            // 
            // _forwardButton
            // 
            this._forwardButton.Enabled = false;
            this._forwardButton.Tag = "__FORWARD__";
            this._forwardButton.Text = "-->";
            this._forwardButton.ToolTipText = "Go Forward";
            // 
            // _exeMenuOption
            // 
            this._exeMenuOption.Index = 4;
            this._exeMenuOption.Text = "Enable resoultion of exe\'s";
            this._exeMenuOption.Click += new System.EventHandler(this.EnableExe);
            // 
            // Form1
            // 
            this.AllowDrop = true;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(856, 481);
            this.Controls.Add(this.listView1);
            this.Controls.Add(this.toolBar1);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Menu = this.mainMenu1;
            this.Name = "Form1";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "Dependency Scanner";
            this.DragDrop += new System.Windows.Forms.DragEventHandler(this.OnDragDropEvent);
            this.DragEnter += new System.Windows.Forms.DragEventHandler(this.OnDragEnter);
            this.ResumeLayout(false);

        }
        #endregion

        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void ResolveGacAsms(object sender, System.EventArgs e) {
            mutex.WaitOne();
            listView1.Cursor = Cursors.WaitCursor;
            Clear(null, null);
            string gacRootPath = Path.GetDirectoryName(Environment.GetFolderPath(Environment.SpecialFolder.System));
            gacRootPath = Path.Combine(gacRootPath, @"assembly\gac");
            DirectoryInfo gacRoot = new DirectoryInfo(gacRootPath);
            DirectoryInfo[] asses = gacRoot.GetDirectories();
            foreach(DirectoryInfo dir in asses) {
                if(true) { // sorry, this used to filter for assemblies of the company I used to work for
                    DirectoryInfo[] asmVers = dir.GetDirectories();
                    foreach(DirectoryInfo folder in asmVers) {
                        foreach(FileInfo dlls in folder.GetFiles("*.dll")) {
                            ResolveAssemblyImports(dlls.FullName);
                            if(InvokeRequired) {
                                AddHelper help = new AddHelper(AddItem);
                                help.BeginInvoke("", "", "", "", "", "", null, null);
                            } else {
                                AddItem("", "", "", "", "", "");
                            }
                        }
                    }
                }
            }
            listView1.Cursor = Cursors.Default;
            mutex.ReleaseMutex();
        }

        private void ResolveAt(object sender, System.EventArgs e) {
            if(folderBrowserDialog1.ShowDialog(this) == DialogResult.OK) {
                Clear(null, null);
                foreach(FileInfo dlls in GetFiles(folderBrowserDialog1.SelectedPath)) {
                    ResolveAssemblyImports(dlls.FullName);
                    AddItem("", "", "", "", "", "");
                }
            }
        }
        private void ResolveAtFile(object sender, System.EventArgs e) {
            if(openFileDialog1.ShowDialog(this) == DialogResult.OK) {
                Clear(null, null);
                ResolveAssemblyImports(openFileDialog1.FileName);
                AddItem("", "", "", "", "", "");
            }
        }
        private FileInfo[] GetFiles(string path) {
            DirectoryInfo root = new DirectoryInfo(path);
            ArrayList subFiles = new ArrayList();
            subFiles.AddRange(root.GetFiles("*.dll"));
            foreach(DirectoryInfo directory in root.GetDirectories()) {
                subFiles.AddRange(GetFiles(directory.FullName));
            }
            return (FileInfo[])subFiles.ToArray(typeof(FileInfo));
        }

        private void Clear(object sender, EventArgs e) {
            listView1.Items.Clear();
            _searchWord = "";
            _caseSen = _matchWhole = _searchSub = false;
        }

        private void ResolveAssemblyImports(string file) {
            try {
                Assembly asm = Assembly.LoadFile(file);
                Assembly d = Assembly.LoadWithPartialName(asm.FullName);
                string ver = "", re = "";
                bool nill = d == null;
                if(!nill) {
                    re = _r.Match(d.FullName).Groups["version"].Value;
                } else {
                    re = "NULL";
                }
                ver = _r.Match(asm.FullName).Groups["version"].Value;
                bool r_1 = false;
                if(ver != re && re != "NULL") {
                    Version v_1 = new Version(ver);
                    Version v_2 = new Version(re);
                    if(v_2 >= v_1) r_1 = true;
                }
                AddItem(asm.GetName().Name, "----", ver, re, "True", nill ? "Failed" : (r_1 ? "True" : "False"));
                foreach(AssemblyName asmName in asm.GetReferencedAssemblies()) {
                    string v1 = _r.Match(asmName.FullName).Groups["version"].Value,
                        v2 = v1;
                    bool exist = false, res = false;
                    Assembly dep;
                    try {
                        dep = Assembly.LoadWithPartialName(asmName.FullName);
                        if(dep != null) {
                            string temp = _r.Match(dep.FullName).Groups["version"].Value;
                            exist = true;
                            if(v2 != temp) {
                                Version v = new Version(v2);
                                Version t = new Version(temp);
                                if(t >= v) res = true;
                            }
                        }
                    } finally {
                        AddItem("    +----", asmName.Name, v1, v2, exist.ToString(), res.ToString());
                    }
                }
            } catch {
            }
        }
        private void AddItem(string asmName, string subAsmName, string version, string resolvedVersion, string exists, string resolves) {
            mutex.WaitOne();
            ListViewItem item = new ListViewItem(new string[] { asmName, subAsmName, version, resolvedVersion, exists, resolves });
            item.UseItemStyleForSubItems = true;
            if(exists.ToLower() == "true") item.ImageIndex = 1;
            else if(exists.ToLower() == "false") {
                item.ImageIndex = 2;
                item.BackColor = Color.LightYellow;
            }
            if(asmName != "    +----" && asmName != "") item.ImageIndex = 0;
            if(resolvedVersion == "NULL") {
                item.BackColor = Color.LightCoral;
                item.ImageIndex = 3;
            }
            listView1.Items.Add(item);
            listView1.Invalidate();
            mutex.ReleaseMutex();
        }

        private void Copy(object sender, System.EventArgs e) {
            string[] ch = {
							  _asmName.Text, 
							  _dAsm.Text, 
							  _reqVer.Text, 
							  _resVer.Text, 
							  _refExists.Text, 
							  _refResolves.Text 
						  };
            string line = "";
            ArrayList lines = new ArrayList();
            int name = ch[0].Length,
                reference = ch[1].Length,
                version = ch[2].Length,
                resolved = ch[3].Length,
                ia = ch[4].Length,
                ib = ch[5].Length;

            foreach(int i in listView1.SelectedIndices) {
                string n = listView1.Items[i].Text,
                    rf = listView1.Items[i].SubItems[1].Text,
                    v = listView1.Items[i].SubItems[2].Text,
                    r = listView1.Items[i].SubItems[3].Text,
                    a = listView1.Items[i].SubItems[4].Text,
                    b = listView1.Items[i].SubItems[5].Text;
                if(n.Length > name) name = n.Length;
                if(rf.Length > reference) reference = rf.Length;
                if(v.Length > version) version = v.Length;
                if(r.Length > resolved) resolved = r.Length;
                if(a.Length > ia) ia = a.Length;
                if(b.Length > ib) ib = b.Length;
                lines.Add(new string[] { n, rf, v, r, a, b });
            }
            if(lines.Count > 0) {
                line = string.Format("{0} {1} {2} {3} {4} {5}\r\n",
                    ch[0].PadRight(name + 1, ' '),
                    ch[1].PadRight(reference + 1, ' '),
                    ch[2].PadRight(version + 1, ' '),
                    ch[3].PadRight(resolved + 1, ' '),
                    ch[4].PadRight(ia + 1, ' '),
                    ch[5].PadRight(ib + 1, ' ')
                    );
                int total = name + reference + version + resolved + ia + ib + 10;
                for(int i = 0; i < total; i++) {
                    line += "=";
                    if(i == total - 1) line += "\r\n";
                }
                foreach(string[] data in lines) {
                    if((name == 0 && reference == 0 && version == 0 && resolved == 0 && ia == 0 && ib == 0)) {
                        line += "\r\n";
                        continue;
                    }
                    line += string.Format("{0} {1} {2} {3} {4} {5}\r\n",
                        data[0].PadRight(name + 1, ' '),
                        data[1].PadRight(reference + 1, ' '),
                        data[2].PadRight(version + 1, ' '),
                        data[3].PadRight(resolved + 1, ' '),
                        data[4].PadRight(ia + 1, ' '),
                        data[5].PadRight(ib + 1, ' ')
                        );
                }
                if(_doCopy) {
                    _copyContents = "";
                    Clipboard.SetDataObject(line, false);
                } else {
                    _copyContents = line;
                }
            }
        }

        private void SelectAll(object sender, System.EventArgs e) {
            foreach(ListViewItem li in listView1.Items) {
                li.Selected = true;
            }
        }

        private void listView1_DoubleClick(object sender, System.EventArgs e) {
            if(listView1.SelectedIndices.Count > 0) {
                string text = listView1.Items[listView1.SelectedIndices[0]].SubItems[1].Text,
                    ver = listView1.Items[listView1.SelectedIndices[0]].SubItems[2].Text;
                if(text != "----" && text.Length > 0 && !text.StartsWith("[")) {
                    _back = listView1.Items[listView1.SelectedIndices[0]];
                    GoToAssembly(text, ver);
                } else if(text == "----" && text.Length > 0 && !text.StartsWith("[")) {
                    HighlightAssembliesThatDependOnMe(listView1.SelectedItems[0].Text);
                }
            }
        }
        private void GoToAssembly(string text, string ver) {
            foreach(ListViewItem item in listView1.Items) {
                string t = item.Text,
                    v = item.SubItems[2].Text;
                if(text.ToLower() == t.ToLower()) {
                    if(ver.ToLower() == v.ToLower()) {
                        _back = listView1.Items[listView1.SelectedIndices[0]];
                        _back1.Enabled = _back2.Enabled = _backButton.Enabled = true;
                        DeselectAll();
                        item.Selected = true;
                        item.EnsureVisible();
                        return;
                    } else {
                        _back = listView1.Items[listView1.SelectedIndices[0]];
                        _back1.Enabled = _back2.Enabled = _backButton.Enabled = true;
                        DeselectAll();
                        item.Selected = true;
                        item.EnsureVisible();
                    }
                    return;
                }
            }
            MessageBox.Show(this, "Can't navigate to that assembly here\t\t", "Oops!", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private void HighlightAssembliesThatDependOnMe(string assemblyName) {
            foreach(ListViewItem item in listView1.Items) {
                if(item.SubItems[1].Text.ToLower() == assemblyName.ToLower()) {
                    item.Selected = true;
                    item.EnsureVisible();
                }
            }
        }
        private void Back(object sender, System.EventArgs e) {
            _forwardButton.Enabled = true;
            DeselectAll();
            _back1.Enabled = _back2.Enabled = _backButton.Enabled = false;
            _back.Selected = true;
            _back.EnsureVisible();
        }

        private void Forward(object sender, System.EventArgs e) {
            _forwardButton.Enabled = false;
            listView1_DoubleClick(null, null);
        }

        private void DeselectAll() {
            foreach(ListViewItem li in listView1.Items) {
                li.Selected = false;
            }
        }

        private void TooBarButtonPress(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e) {
            if((string)e.Button.Tag == "__BACK__") {
                _forwardButton.Enabled = true;
                Back(null, null);
            } else if((string)e.Button.Tag == "__FORWARD__") {
                _forwardButton.Enabled = false;
                listView1_DoubleClick(null, null);
            } else if((string)e.Button.Tag == "__FOLDER__") {
                ResolveAt(null, null);
            } else if((string)e.Button.Tag == "__FILE__") {
                ResolveAtFile(null, null);
            } else if((string)e.Button.Tag == "__GAC__") {
                ResolveGacAsms(null, null);
            }
        }

        private void OnDragEnter(object sender, System.Windows.Forms.DragEventArgs e) {
            string filename = ((string[])e.Data.GetData("FileName"))[0].ToLower();
            if((Path.GetExtension(filename).ToLower() == ".dll" || (_enableExes && Path.GetExtension(filename).ToLower() == ".exe")) || Directory.Exists(filename)) {
                e.Effect = DragDropEffects.All;
            } else
                e.Effect = DragDropEffects.None;
        }

        private void OnDragDropEvent(object sender, System.Windows.Forms.DragEventArgs e) {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            foreach(string file in files) {
                DirectoryInfo d = new DirectoryInfo(file);
                if(files != null) {
                    if(d.Extension.Length > 0) {
                        FileInfo fileName = new FileInfo(file);
                        if(fileName != null && fileName.FullName.Length > 0 && (Path.GetExtension(fileName.FullName).ToLower() == ".dll" || (_enableExes && Path.GetExtension(fileName.FullName).ToLower() == ".exe"))) {
                            if(Path.GetExtension(fileName.FullName.ToLower()) == ".dll" || (_enableExes && Path.GetExtension(fileName.FullName).ToLower() == ".exe")) {
                                ResolveAssemblyImports(fileName.FullName);
                                AddItem("", "", "", "", "", "");
                            }
                        }
                    } else if(d.Extension.Length == 0) {
                        foreach(FileInfo dlls in GetFiles(d.FullName)) {
                            if(Path.GetExtension(dlls.FullName.ToLower()) == ".dll" || (_enableExes && Path.GetExtension(dlls.FullName).ToLower() == ".exe")) {
                                ResolveAssemblyImports(dlls.FullName);
                                AddItem("", "", "", "", "", "");
                            }
                        }
                    }
                }
            }
            Activate();
            Focus();

        }

        private void OnMouseDown(object sender, System.Windows.Forms.MouseEventArgs e) {
            if(_drgFrom.Checked) {
                if(e.Button == MouseButtons.Left) {
                    if(listView1.SelectedItems.Count > 0) {
                        lock(_lock) {
                            _doCopy = false;
                            if(_copyContents == "")
                                Copy(null, null);
                            DragDropEffects dde = DoDragDrop(_copyContents, DragDropEffects.All);
                            DeselectAll();
                            _doCopy = true;
                            _copyContents = "";
                        }
                    }
                }
                Message m = Message.Create(listView1.Handle, WM_LBUTTONUP, IntPtr.Zero, IntPtr.Zero);
                WndProc(ref m);
            }
        }

        private void DragFromEnabled(object sender, System.EventArgs e) {
            _drgFrom.Checked = !_drgFrom.Checked;
        }

        private void Find(object sender, System.EventArgs e) {
            Find f = new Find(_searchWord, _caseSen, _searchSub, _matchWhole);
            if(f.ShowDialog(this) == DialogResult.OK) {
                _searchWord = f.SearchWord;
                _caseSen = f.CaseSensitive;
                _searchSub = f.SearchSubNodes;
                _matchWhole = f.MatchWholeWord;
                FindWord(_searchWord, _caseSen, _matchWhole, _searchSub);
                f.Dispose();
            }
        }
        private void FindWord(string searchWord, bool caseSensitive, bool whole, bool sub) {
            if(listView1.Items.Count > 0) DeselectAll();
            foreach(ListViewItem item in listView1.Items) {
                string pat = whole ? "^" + searchWord + "$" : ".*" + searchWord + ".*";
                RegexOptions options = (caseSensitive ? RegexOptions.None : RegexOptions.IgnoreCase);
                if(Regex.IsMatch(item.Text, pat, options)) {
                    item.Selected = true;
                    item.EnsureVisible();
                }
                if(sub) {
                    if(Regex.IsMatch(item.SubItems[1].Text, pat, options)) {
                        item.Selected = true;
                        item.EnsureVisible();
                    }
                }
            }
        }

        private void EnableExe(object sender, System.EventArgs e) {
            _enableExes = !_exeMenuOption.Checked;
            _exeMenuOption.Checked = _enableExes;
        }
        delegate void AddHelper(string asmName, string subAsmName, string version, string resolvedVersion, string exists, string resolves);
    }
}
