using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace DependencyResolver {
    public class Find : System.Windows.Forms.Form {
        private const int WM_CLOSE = 0x0010;
        private System.Windows.Forms.TextBox _asmName;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.CheckBox _case;
        private System.Windows.Forms.Button _find;
        private System.Windows.Forms.Button _cancel;
        private System.Windows.Forms.CheckBox _word;
        private System.Windows.Forms.CheckBox _subNodes;
        private System.ComponentModel.Container components = null;

        public Find(string searchWord, bool caseSensitivity, bool searchSubNodes, bool matchWholeWord) {
            InitializeComponent();
            _asmName.Text = searchWord;
            _case.Checked = caseSensitivity;
            _word.Checked = matchWholeWord;
            _subNodes.Checked = searchSubNodes;
        }

        public string SearchWord {
            get{return _asmName.Text;}
        }
        public bool CaseSensitive {
            get{return _case.Checked;}
        }
        public bool SearchSubNodes {
            get{return _subNodes.Checked;}
        }
        public bool MatchWholeWord {
            get{return _word.Checked;}
        }

        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region 
        private void InitializeComponent() {
            this._asmName = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this._case = new System.Windows.Forms.CheckBox();
            this._find = new System.Windows.Forms.Button();
            this._cancel = new System.Windows.Forms.Button();
            this._word = new System.Windows.Forms.CheckBox();
            this._subNodes = new System.Windows.Forms.CheckBox();
            this.SuspendLayout();
            // 
            // _asmName
            // 
            this._asmName.Location = new System.Drawing.Point(96, 8);
            this._asmName.Name = "_asmName";
            this._asmName.Size = new System.Drawing.Size(168, 20);
            this._asmName.TabIndex = 0;
            this._asmName.Text = "";
            // 
            // label1
            // 
            this.label1.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.label1.Location = new System.Drawing.Point(8, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(88, 16);
            this.label1.TabIndex = 1;
            this.label1.Text = "Find Assembly:";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _case
            // 
            this._case.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._case.Location = new System.Drawing.Point(16, 32);
            this._case.Name = "_case";
            this._case.Size = new System.Drawing.Size(120, 16);
            this._case.TabIndex = 2;
            this._case.Text = "Match Case";
            // 
            // _find
            // 
            this._find.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._find.Location = new System.Drawing.Point(280, 8);
            this._find.Name = "_find";
            this._find.TabIndex = 3;
            this._find.Text = "Find All";
            this._find.Click += new System.EventHandler(this._find_Click);
            // 
            // _cancel
            // 
            this._cancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this._cancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._cancel.Location = new System.Drawing.Point(280, 49);
            this._cancel.Name = "_cancel";
            this._cancel.TabIndex = 4;
            this._cancel.Text = "Cancel";
            // 
            // _word
            // 
            this._word.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._word.Location = new System.Drawing.Point(16, 48);
            this._word.Name = "_word";
            this._word.Size = new System.Drawing.Size(120, 16);
            this._word.TabIndex = 5;
            this._word.Text = "Match Whole Word";
            // 
            // _subNodes
            // 
            this._subNodes.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._subNodes.Location = new System.Drawing.Point(16, 64);
            this._subNodes.Name = "_subNodes";
            this._subNodes.Size = new System.Drawing.Size(112, 16);
            this._subNodes.TabIndex = 6;
            this._subNodes.Text = "Search Sub Nodes";
            // 
            // Find
            // 
            this.AcceptButton = this._find;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this._cancel;
            this.ClientSize = new System.Drawing.Size(362, 90);
            this.ControlBox = false;
            this.Controls.Add(this._subNodes);
            this.Controls.Add(this._word);
            this.Controls.Add(this._cancel);
            this.Controls.Add(this._find);
            this.Controls.Add(this._asmName);
            this.Controls.Add(this._case);
            this.Controls.Add(this.label1);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.Name = "Find";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Find";
            this.ResumeLayout(false);

        }
        #endregion

        private void _find_Click(object sender, System.EventArgs e) {
            DialogResult = DialogResult.OK;
        }
        protected override void WndProc(ref Message m) {
            if(m.Msg == WM_CLOSE) {
                m.Msg = 0;
                m.Result = (IntPtr)1;
                Hide();
            }
            base.WndProc (ref m);
        }

    }
}
